//
//  Material.vsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//


#ifdef OGL_ES2

#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

#define prec_high highp
#define prec_med mediump
#define prec_low lowp

#else 

#define prec_high
#define prec_med 
#define prec_low 

#endif

uniform prec_high mat4 u_modelViewMatrix;
uniform prec_high mat4 u_modelViewProjectionMatrix;
 
uniform prec_med vec3 u_frustumPlanes;
 
varying prec_med vec3 v_world_xyz;
varying prec_med vec3 v_world_normal;
 
attribute vec4 a_position;
attribute vec4 a_normal;
 
void main()
{ 
	gl_Position = u_modelViewProjectionMatrix * a_position;
 
	// viewspace normal and position
	v_world_normal = (u_modelViewMatrix * a_normal).xyz;
	v_world_xyz =  (u_modelViewMatrix * a_position).xyz;
}

